Version 7.1.2 Build 226
--------------------------

* Fixed: Critical: Black screen workaround for 10.13.2 graphics driver bug
* Fixed: Mouse might get stuck in the center of the screen

Version 7.1.1 Build 225
--------------------------

* Fixed: URL handler does not respect the 'password' parameter
* Stability fixes

Version 7.1 Build 224
---------------------

* Fixed: RDP: When copy pasting files, files with '..' in the name are not copied properly
* Fixed: RDP: German/DE keyboard appears in the remote session

Version 7.1 Build 223
---------------------

* Fixed: RDP: Copy pasting files could randomly fail
* Added more logging to diagnose keyboard input problems
* Stability

Version 7.1. Build 222
----------------------

* Fixed: RDP resolution doesn't update when in split-view fullscreen mode
* Fixed: Prevent main window from being shown when launching .jump shorcuts
* Fixed: Another case where the remote apps changed position after disconnecting
* Fixed: Remote desktop window gets resized and reposition during reconnect
* Fixed: Regression: Can't retrieve diagnostic logs

Version 7.1 Build 221
---------------------

* New: RDP: Pasteboard file transfers: You can now copy files on the remote computer and paste it via Finder (and vice versa)
* New: RDP: Ability to specify the default printer on per connection basis: You can now choose whether or not the default printer is set in the remote session and which local printer it defaults to: Right click your computer's icon and click Edit -> Sharing
* New: Use SHA256 fingerprints when identifying SSH servers
* New: More server icons added
* Fixed: VNC: Cannot connect to VMWare Fusion's VNC server when the password is incorrect
* Fixed: RDP: Remote screen is resized before disconnecting, causing remote apps to resize and change position


Version 7.1 Build 220
---------------------

* New: Quick connections respect tab settings
* New: Main window remembers its size and position when you quit.
* New: OpenBSD puffy icon to the icons collection
* New: Minimum size of main window is reduced so that it optionally occupies less space on your screen
* Fixed: Sidebar does not un-collapse in certain cases
* Fixed: Show/Hide Sidebar menu item does not show correct label if sidebar is
  collapsed by dragging the divider to the left
* Fixed: Sidebar is very small with truncated labels if window size is small
* Fixed: Main window does not respect tab preferences
* Fixed: VNC: Left click doesn't work properly when connecting to macOS High Sierra
* Stability

Version 7.0.7 Build 215
-----------------------

* Fixed: RDP: Delay while syncing clipboard
* More Stability fixes

Version 7.0.7 Build 214
-----------------------

* Fixed: RDP: RD Gateway connections may fail after the first connection
  attempt
* Fixed: RDP: Printing: Printer redirection stopped working (regression in
  build 213)
* Fixed: RDP: Printing: Don't override the default printer setting on the
  remote computer
* Fixed: RDP: Cmd+C etc shortcuts don't work properly on Cyrillic keyboards
* More Stability fixes

Version 7.0.7 Build 213
-----------------------

* Fixed: VNC: Regression that caused clipboard syncing to stop working on Linux
* Fixed: VNC: Regression that caused the last character of the clipboard to be
  cut off when connect to a Mac
* Fixed: Ctrl key stopped working on Cyrillic keyboards
* Fixed: Menu shortcuts stopped working on Cyrillic keyboards
* Stability

Version 7.0.7 Build 212
-----------------------

* Possible fix for a crash after dismissing the quick connect dialog

Version 7.0.6 Build 211
-----------------------

* Fixed: Clipboard might have extra null characters (\0) suffixed at the end


Version 7.0.6 Build 210
-----------------------

* Changed: Signing into your Google or Jump Desktop account now happens via
  macOS's default web browser
* Fixed: Regression: macOS dictation stopped working
* Fixed: Remote screen is not correctly position when the macOS Dock is left or
  right aligned
* Fixed: Keys might remain 'stuck' when switching windows
* Updated encryption library
* Stability fixes

Version 7.0.5 Build 207
-----------------------

* Update Setapp library to 1.0

Version 7.0.5 Build 206
-----------------------

* Fixed: RDP: Potential crash when connecting to redirected servers
* Stability fixes

Version 7.0.5 Build 205
-----------------------

* Potential for quick connect crash: Fixed a IPv6 memory corruption bug that
  may cause crashes during quick connect and/or when connecting directly to
  hosts
* Reverts NumLock changes in build 204 which caused a regression from build 203


Version 7.0.5 Build 204
-----------------------

* Fixed: Key conversion: When Cmd is remapped to Alt, pressing Shift + Cmd + P
  does not correctly send Shift + Alt + P to the remote machine
* Fixed: Fluid remote dsektop doesn't send NumLock properly to the remote
  machine
* Fixed: RDP: Remember NumLock state across restarts. OSX doesn't maintain the
  state of NumLock so Jump will maintain the state itself.
* Fixed: Can not reorder Tags on the sidebar

Version 7.0.4 Build 203
-----------------------

* Fixed: RDP: Changing scale settings doesn't work when using a custom
  resolution
* Beta builds now automatically submit crash reports
* Stability

Version 7.0.4 Build 202
-----------------------

* Fixed: RDP: Incorrect resolution when waking up from sleep

Version 7.0.4 Build 201
-----------------------

* A possible fix for a bug that my cause Jump to set the wrong resolution for
  RDP sessions after waking up

Version 7.0.3 Build 200
-----------------------

* Fixed: Key mapping shortcuts may occasionally stop working when connecting to
  Windows machines
* Stability

Version 7.0.2 Build 199
-----------------------

* Update SetApp library

Version 7.0.2 Build 198
-----------------------

* Fixed: Fluid: Flicker when switching monitors
* Fixed: Cycle monitor shortcut does not work after connecting

Version 7.0.2 Build 197
-----------------------

* Fixed: More IPv6 related issues when using Jump Desktop Connect
* Fixed: RDP: Jump did not set the correct resolution when connecting to
  Windows 7/Vista/XP Pro with multi-monitors

Version 7.0.2 Build 196
-----------------------

* Fixed: CAPSLOCK doesn't engage reliably
* Fixed: Remove trailing and leadning whitespace from LoadBalancerInfo when
  manually editing it in the UI

Version 7.0.2 Build 195
-----------------------

* Fixed: Key conversions that required 'Alt' to be pressed may cause extra Alts
  to be send to the remote computer
* Fixed: RDP: Windows 8.1 does not scale the 'Start' screen properly

Version 7.0.2 Build 194
-----------------------

* New: Support for adding and storing load balaner info from RDP files
* Fixed: RDP: HTML pasting problems from Firefox
* Fixed: Screen zooms out when switching spaces

Version 7.0.2 Build 193
-----------------------

* Fixed: Keyboard modifiers on the right of the keyboard stopped working
* Fixed: Intermittent problems when trying to log into Google using 2-factor atuh
* Fixed: Screen freezes when mouse panning is enabled and dock appears
* Fixed: Rendering artifact in the main window's listview

Version 7.0.2 Build 192
-----------------------

* New: Add default key mappings when connecting to Macs to help make common
  tasks easier: Window switching, Spotlight and switching spaces
* Fixed: Crash on startup if the cache directory is not present
* Fixed: IPv6 fixes for automatic connections
* Fixed: Some key conversions stopped working if conversion rules had
  overlapping modifiers
* Fixed: RDP: 'Match keyboard layout' stopped working for international
  keyboard layouts
* Fixed: RDP: Resizing the screen while connected to Win 8.1 or later caused
  resolution updates even if a fixed resolution was set
* Fixed: RDP: RTF text was no longer retrived correctly

Version 7.0.1 Build 191
-----------------------

* Fixed: SetApp only: Update SetApp library to 0.6.2
* New: Add default key mappings for Macs to help make common tasks easier:
  Window switching, Spotlight and switching spaces

Version 7.0.1 Build 190
-----------------------

* Fixed: RDP: Redirection may cause issues when connecting to Server 2012 R2
* Fixed: TextExpander and aText paste text twice

Version 7.0.1 Build 189
-----------------------
Released Dec 29th 2016

* Fixed: Crash when Remote -> Send Ctrl Alt Delete

Version 7.0.1 Build 188
-----------------------
Released Dec 28th 2016

* Fixed: Remote -> Send Keys stopped working
* Fixed: Crash when disconnecting and leaving full screen

Version 7.0.1 Build 186
-----------------------
Released Dec 22nd 2016

Please Note: You will have to re-login into your Jump Desktop account after you
update.

* New: 'Always show Tab Bar in Fullscreen' option in General Preferences.
* Fixed: Random connection issues / freezes when Jump Desktop Beta and
  Production are running at the same time. Requires relogin into the Beta app.
* Fixed: All computers appear offline on IPv6-only networks
* Fixed: Fluid: Spacebar does not work correctly in Adobe Acrobat
* Fixed: More fixes for bug that causes keys to remain pressed
* Fixed: Performance regression when connecting to RDP and VNC connections

Version 7.0.1 Build 185
-----------------------
Released Dec 18th 2016

* Fixed: Some keys may remain in stuck position
* Fixed: Crash when going full screen on multiple monitors

Version 7.0.1 Build 184
-----------------------
Released Dec 14th 2016

* Fixed: Fluid: Clipboard line endings were not properly converted
* Fixed: Tab bar is shown in fullscreen mode when 'Hide Menubar' is enabled in
  generat options
* Fixed: HUD UI isn't shown when switching tabs
* Fixed: Win key may be triggered when the command key is completely remapped
  to ctrl

Version 7.0 Build 183
---------------------
Released Nov 9th 2016

Note: This is the final 7.0 build. If you hit any issues please report ASAP to
betasupport@jumpdesktop.com. Thank you very much for helping beta test Jump
Desktop 7.0 for Mac.

* Fixed: RDP: Multiple monitor and fullscreen options were not correctly read
  from .rdp files
* Fixed: Suprious “Mac OS X Shortcuts enabled” message shown after connecting
  to a remote
* Fixed: Update text “Mac OS X” to “macOS”


Version 7.0 Build 182
---------------------
Released Nov 8th 2016

* Critical: Fixed: Crash on macOS 10.11 and earlier when connecting
* Changed: Disable tab open mode preferences on systems not running macOS 10.12
  or later
* Fixed: Connections opened via .rdp files now match the screen resolution

Version 7.0 Build 181
---------------------
Released Nov 8th 2016

* Critical: RDP File Redirection: All files were not be copied when “Cut” and
  “Paste” is used Explorer on the remote computer (leads to data loss)
* New: The Tab bar is automatically hidden when a connection is fullscreen
* New: Keyboard shorcuts for cycling between tabs. Be sure to enable the
  shortcuts in Jump -> Preferences -> Keyboard & Mouse -> Keyboard Shortcuts
* Changed: When Jump’s “Prefer Tab” preference is set to “Always”, fullscreen
  connections will be launched as a tab inside a fullscreen window
* Fixed: RDP: Custom resolution is not correctly applied for RDP sessions
* Fixed: VNC: Extra line endings added to pasteboard when connecting to Linux
* Fixed: Keyboard shortcuts don’t work while connecting to a computer
* Stability

Version 7.0 Build 180
---------------------
Released Oct 28th 2016

* Fixed: RDP: Crash when connecting to RD Gateway servers

Version 7.0 Build 179
---------------------
Released Oct 28th 2016

* New: Re-added settings to control Tabs in Preferences: You can choose
  between: "Always", "Never", "Only in Full Screen" and "Use Dock defaults"
* Changed: Sidebar does not resize with main window
* Changed: Make warning message clear that deleting a tag will also delete its
  child tags
* Fixed: Status column in list view is not automatically updated
* Fixed: ⌘Command+W does not close the main window
* Fixed: ⌃Control+LeftClick does not display context menu in main window
* Fixed: Connection is launched in a tab if "Prefer tabs when opening
  documents" in "System Preferences → Dock" is set to open in fullscreen only
* Fixed: Could not import connections
* Fixed: Vertical scrolling was too sensitive for Fluid connections
* Fixed: Capslock did not work properly for Fluid and RDP (Fluid fixes requires
  Jump Desktop Connect 5.0.48:
  [Win](https://jumpdesktop.com/downloads/connect/JumpDesktopConnect-5.0.48.0.exe)
  [Mac](https://jumpdesktop.com/downloads/connect/JumpDesktopConnect-5.0.48.dmg))
* Fixed: Keypad keys stopped working
* Fixed: Control + Click inside remote screen was incorrectly translated to
  right click
* Fixed: Keyboard mappings were not correctly imported when mmigrating from
  Jump Desktop 6.x
* Fixed: RDP: Clipboard contained extra null (\0) characters
* Fixed: RDP: Clipboard did not correctly translate international characters in
  some apps
* Fixed: RDP: Clipboard transfer from Mac to Windows did not paste properly in
  some apps
* Stability fixes

Version 7.0 Build 178
---------------------
Released Oct 19th 2016

* Fixed: Critical: Scrolling caused a crash

Version 7.0 Build 177
---------------------
Released Oct 19th 2016

* **Note**: To "Always Open Computers in Tab", open System Preferences → Dock.
  Set "Prefer tabs when opening documents" to Always.
* Changed: A computer set to start in fullscreen will always start in
  fullscreen, regardless of system preferences, unless user choses to:
  1. Connect in New Tab
  2. Connect in New Tabbed Window

* Fixed: Tag count is incorrect in the sidebar
* Fixed: Tag count is not updated if a selected tag is expanded or collapsed
* Fixed: In the sidebar, if a selected tag's parent tag is collapsed, selection
  is lost but computer view shows selected tag's computers. Now Jump shows all
  computers if selected tags is hidden
* Stability fixes

Version 7.0 Build 176
---------------------
Released Oct 5th 2016

* New: RDP: Configurable Desktop Scaling settings on Windows 8.1 and later:
  Connect to your remote and click Remote -> Displays -> Desktop Scale
* New: RDP: Redesigned "Display" settings pane
* Fixed: TextExpander and third party clipboard managers stopped working with
  Jump
* Fixed: Over-sensitive trackpad scroll on macOS Sierra
* Fixed: Passwords may not be saved for automatic connections
* Fixed: Potential fix for JIS and Pinyin keyboard layouts not sending the
  correct characters
* Fixed: RDP: Increase maximum clipboard transfer size to 128mb
* Fixed: Computers, Discovered and Recent were not center aligned vertically
* Fixed: Main window size got messed up if windows are set to open always in
  tab in OS X system preferences
* Changed: Removed "Always open in tab" option from general preferences
* Changed: RDP: Computers opened using .rdp files now always match the displays
  resolution by default

Version 7.0 Build 175
---------------------
Released Sep 28th 2016

* Fixed: Multi-monitor support on 10.11+. Thank you for your patience!
* New: RDP: Dynamic resolution updates when connecting to Windows 8.1+. Jump
  will now automatically resize the remote desktop if you've selected 'Match
  Resolution' or 'Match Resolution with Retina' in 'Display' settings.
* New: RDP: Add support for 'loadbalancerinfo' in RDP files
* Fixed: Key mappings and key conversion fixes: New key conversions added
  through the UI now will work even when Alt is pressed.
* Fixed: Bonjour / Discovered computer detection causes Jump to slow down when
  there are alot of computers on the local network. Jump will only start
  detecting computers when you click the 'Discovered' view.
* Fixed: Tabbing related fixes on macOS Sierra.

Version 6.1.0 Build 174
-----------------------
Released Sep 13th 2016

*Known issue*: Fullscreen + multi-monitor support is broken on 10.11+ due to a
breaking API change in the latest macOS SDK. The fix requires rewriting alot of
existing code -
we're still working on a fix for this. Sorry for the
inconvenience.

* New: Tab support. Open connections in tabs. Requires macOS Sierra (10.12+).
  Right click a connection and then click "Connect In New Tab". To merge tabs
  make sure both Windows have tabs showing by click View -> Show Tabs. Then
  drag and drop your tab to the new window. Also, you can make sure all
  connections open up in a new tab by enabling: Jump Desktop -> Preferences ->
  Open all remote computers in a tab.
* Fixes for macOS Sierra
* Fixed: Key mapping issues
* Fixed: Crash when connecting to certain VNC servers

Version 6.1.0 Build 172
-----------------------
Released Aug 8th 2016

*Known issue*: Fullscreen + multi-monitor support is broken on 10.11+ due to a
breaking API change in the latest macOS SDK. We're working on a fix for this.
Sorry for the inconvenience.
* New: Ability to remap modifiers completely (i.e. Control to Cmd, Alt to Cmd
  etc)
* New: Ability to remap persistent key strokes like Alt+Tab to Cmd+Tab etc.
* New: Keyboard Input: Press Right Alt to send special symbols to the remote
  machine. Press Left Alt for accelerator shortcuts.
* Fluid: Fixes for international keyboards. Note: Requires Jump Desktop Connect
  5.0.24+
* Fixed: Crash when using the search field

Version 6.1.0 Build 171
-----------------------
Released July 21 2016

Critical fix: Fixes crash when connecting to Fluid connections. Sorry about
this!

Read on to find out whats new in 6.1.0…

Version 6.1.0 Build 170
-----------------------
Released July 21 2016

Important notice: This version removes support for the legacy Jump Desktop
automatic connection app (version 3.x and earlier). Please make sure your
machines are running Jump Desktop Connect from here:
https://jumpdesktop.com/go.

* New: Scroll to and select newly added computer
* New: Scroll to and select sidebar selection from previous session when Jump
  Desktop restarts
* New: Import mRemote connections
* New: Fluid: Performance and stability updates
* Fixed: In some cases, user ends up with an empty computers list
* Fixed: In some cases, nested tags are not present in Connect To menu of the
  dock icon's context menu
* Fixed: Sidebar selection changes when user edits, duplicates or adds a new
  computer
* Fixed: A bug that let user to drag and drop a tag on VIEW, Computer, Recent,
  Discovered in the sidebar, which are invalid destinations
* Fixed: A bug that caused user to have empty selection in the sidebar
* Stability and performance

Version 6.0.3 Build 168
-----------------------

* Fixed: Automatic connections occasionaly lose their settings after updating
  to Jump Desktop Connect on the remote computer

Version 6.0.3 Build 167
-----------------------

* Fixed: RDP: Fix an issue where the mouse cursor isn't updated correctly on
  multi-monitor setups

Version 6.0.3 Build 166
-----------------------

* Fixed: El Capitan: Remote screen did not properly resize (appeared very
  small) under certain conditions
* Fixed: RDP: Server side pointer movement requests were being ignored.

Version 6.0.2 Build 165
-----------------------

* Fixed: VNC: Cmd+Tab and certain shortcuts were not working properly when
  connected to Mac remotes

Version 6.0.1 Build 164
----------------------
Released Oct 1st 2015

Stability and bug fixes:

* Fixed: Crash in some cases when there was a problem accessing the keychain
* Fixed: Memory leaks when connecting to Fluid connections
* Fixed: Occasional crash when connecting to automatic connections
* Fixed: Duplicated legacy automatic connections were not upgraded properly
  when "Jump Desktop Connect" was installed on the remote system
* Fixed: Wake-after-sleep showed all automatic connection computers offline
* Fixed: Menubar stopped working after dismissing the crash reporting dialog

Version 6.0 Build 163
---------------------
Released Sep 5th 2015

* Fixed: Signing out does not sign out user from legacy Google automatic
  connection

Version 6.0 Build 162
---------------------
Released Sep 5th 2015

* Fixed: Filter bar labels were cut off on OS X 10.8 and 10.9
* Fixed: When starting for the first time, the sidebar would cover the entire
  Window

Version 6.0 Build 161
---------------------
Released Sep 4th 2015

* Fixed: RDP: Onscreen / touch keyboard should not be shown when logging into
  Windows 8, 8.1 and 10.

Version 6.0 Build 160
---------------------
Released Sep 3rd 2015

* Stability and security fixes

Version 6.0 Build 159
---------------------
Released Sep 2nd 2015

* New: Show Discovered computers in the dock menu
* Fixed: Duplicates may appear in "Connect To" dock menu
* Fixed: Fixes for connections using legacy version of Jump Desktop server
* Bug fixes for Fluid connections

Version 6.0 Build 158
---------------------
Released Aug 17th 2015

* New: Toolbar button to show and hide filter bar
* Fixed: Crash when configuring RDP connections' advanced settings
* Fixed: Regression in 157 that caused crashes when connecting via Fluid


Version 6.0 Build 157
---------------------
Released Aug 11th 2015

* Updated: Adds tag field in the new connection window which lets user set tags
  when creating a new connection
* Fixed: Crash when disconnecting from a Fluid connection

Version 6.0 Build 156
---------------------
Released Aug 6th 2015

* New: RDP: Support for Windows 10 Desktop scaling. Jump will automatically
  calculate and apply a comfortable scaling factor when connecting to Windows
  10.
* New: RDP: Adds a new resolution option for RDP that uses full Retina
  resolution when availabile. You no longer need to manually specify retina
  resolution. This works in Windowed mode as well.
* New: Adds a new shortcut for cycling through remote displays:
  Control+Cmd+Right Arrow
* Updated: Removed special icon for Templates
* Updated: Templates can now be nested in the sidebar like regular tags. Ie.
  Lab\Templates, Home\Templates etc
* Fixed: Mouse pointers were very large when connecting to HiDPI remotes
* Fixed: Monitor selection menu not updated when the remote screen
  configuration changes
* Fixed: An issue where PCs running the old Jump Desktop server app were
  reported as offline
* Fixed: "Ignore Certificate Errors" option was inverted in the UI
* Fixed: Tooltips appear offscreen
* Performance fixes

Version 6.0 Build 155
---------------------
Released July 30th, 2015

* Performance and Energy optimizations
* Fixed: Occasionally computers that were online were shown as offline
* Fixed: Prompt the user to sign-in when trying to connect to automatic
  connections while signed out
* Fixed: Duplicating connections did not duplicate passwords
* Fixed: Automatic connections no longer show the localhost's icon (requires
  Jump Desktop Connect Mac 4.6.4+)
* Fixed: Blurred text in start up screen
* Fixed: Crash when multiple RDP connections were opened at once

Version 6.0 Build 154
---------------------
Released July 20th, 2015

* New: Performance and stability updates for Fluid connections. Please make
  sure you're running Jump Desktop Connect for Windows 4.6.0 on the target
  machine (released today).
* New: Clipboard syncing for Fluid connections. Make sure you enable the
  clipboard syncing option by editing your computer's settings: Click on the
  "Share" row and enable the "Clipboard" option.New connections will enable
  this by default.
* New: Monitor selection for Fluid connectins: When connecting to multi-monitor
  machines click Remote -> Display to select an individual display.


Version 6.0. Build 153 ====================== Released June 25th 2015

**Important Note**: The last release email had incorrect URLs for **Jump
Desktop Connect**. Here are the correct URLs:

1. Windows Download:
[https://s3.amazonaws.com/jumpdesktop.com/downloads/connect/JumpConnectInstaller.exe](https://s3.amazonaws.com/jumpdesktop.com/downloads/connect/JumpConnectInstaller.exe)

2. Mac Download:
[https://s3.amazonaws.com//jumpdesktop.com/downloads/connect/JumpDesktopConnect.dmg](https://s3.amazonaws.com//jumpdesktop.com/downloads/connect/JumpDesktopConnect.dmg)


Build 153 is a minor bug fix follow up to build 152. It fixes a bug with domain
based logins when connecting to Fluid connections. Read on to learn whats new
in build 152.

Sorry about the URL mixup!


Version 6.0 Build 152 ===================== Released June 25th 2015

WHAT'S NEW?
------------

**Jump Desktop Fluid**

In this release we're introducing a brand new way to access your computers.
We're calling it: Jump Desktop Fluid. **Fluid** is a brand new protocol
designed for very high performance screen sharing. Fluid can share you screen
at 30fps while using only 1/10th of the bandwidth when compared to traditional
protocols like RDP and VNC. With Fluid you'll be able to manage your servers,
work on your documents, edit/watch movies and photos and even play games
remotely.

**How to get started with Fluid**

Fluid comes built into Jump Desktop Connect 4.5 (released yesterday). At the
moment Fluid is only available when connecting to Windows machines (Mac support
will be released later).

To get started:

1. Open up Jump Desktop Connect and click the settings icon on the top right
hand corner.
2. In the **Advanced** section make sure the **Fluid Remote Desktop** checkbox
is checked. If you don't see the **Fluid Remote Desktop** checkbox, click on
**Diagnostics** and make sure you're running version 4.5.0 and later.
3. Make sure you've updated to the latest Jump Desktop for Mac (build 152+) and
Jump Desktop for iOS (build 138+).
4. You should now see a new, light blue icon for your computer with "Fluid" in
the name. Click it to connect:

![image](http://grab.by/Ihwe)

Note: You'll be prompted for **Windows Credentials** when you connect. Use any
valid Windows account on the machine to connect. Accounts with blank passwords
are not accepted -
so make sure the user account you're logging in with has a
password set.

If you haven't already installed the new Jump Desktop Connect app on your
machine:

[Jump Desktop Connect for Windows
Download](https://s3.amazonaws.com/jumpdesktop.com/downloads/connect/JumpConnectInstaller.exe)

[Jump Desktop Connect for Mac
Download](https://s3.amazonaws.com//jumpdesktop.com/downloads/connect/JumpDesktopConnect.dmg)

As always -
any feedback is highly appreciated. Send feedback via HockeyApp or
directly to betasupport@jumpdesktop.com .

### Some More Goodies

**Bulk Editing**

One of the most requested features. You can select any number of computers in
any order and edit their settings simultaneously. Try editing VNC and RDP
computers together!

![Bulk edit example](http://i.imgur.com/W9UHTec.png)

**Templates**

Another feature for power users. Templates are computers that you can copy
settings from when creating new connections or using quick connect.

![Template Demonstration in New Connection](http://i.imgur.com/2lrUC3J.gif)

You can make a computer a template by adding tag "Templates" or dragging it
into the Templates folder in the sidebar.

![Templates in sidebar](http://i.imgur.com/UjSODto.png)

**Tags in "Connect To" menu**

Computers in the "Connect To" menu are not grouped into their tags. Instead of
one long list of computers you get a nice categorized list. Also computers in
the menu are sorted according to the active sort criteria of computers list in
main window.

![Tags in Dock Connect To menu](http://i.imgur.com/szs4qQs.png?1)

### Bug fixes

**Rate App Prompt**

In this version, we have enabled rate app prompt for beta users. Few users have
reported a bug related to rate app prompt feature, which unfortunately we have
been unable to reproduce. We have enabled this prompt for beta users in the
hope that some of you might come accross the elusive bug and report it to us
with logs, which in turn will help us swat the bug.

![Rate App](http://i.imgur.com/EoIRVRj.png)

**Other bug fixes**
1. Duplicate connections end up in the list and cannot be deleted
1. Sidebar takes up all window space

Version 6.0 Build 151
---------------------
Fixes a code signing issue with
build 150

Version 6.0 Build 150
---------------------
Released May 7 2015

Hello and welcome to Jump Desktop for Mac 6.0 Beta.

**WHAT'S NEW?**

This is a relatively big release. We're actually releasing 3 new components
today:

1. A new cloud backend for automatic connections.
2. A new automatic setup app that connects to the new cloud backend.
3. Jump Desktop for Mac 6.0 Beta.

*New cloud backend for automatic connections*

In this release we're revamping how automatic setup works. We're introducing a
new cloud backend that doesn't require Google accounts or access to Google's
servers. Here's some new features that the new backend supports:

* Virtually unlimited number of computers can be managed using the same
  account. This gets us past Google's limit of only ~7 computers for
  non-Google-Apps accounts.

* You're no longer restricted to using a Google account for registration -
any
  email address will work. Ofcourse, you can still login with your existing
  Google account by clicking the "Sign in with Google" button.

* More than one account can now be associated with a computer. For example: You
  can now give yourself and your co-workers access to the same computer without
  the need to share passwords. Here's a screenshot that shows 4 users that have
  access to the same computer:

![image](http://grab.by/H5Rk)


*Jump Desktop Connect*

We're also releasing a new automatic setup component that we're calling: **Jump
Desktop Connect**. This will eventually replace the existing Windows and Mac
automatic setup components. Besides having all the features of the older
automatic setup component, here's some new stuff in Jump Desktop Connect:

* Automatic updates for easy management: No need for user intervention when new
  updates are avaialble. This feature can NOT be switched off during the beta
  but the final release will have an option to turn it off.

* Self contained: For Windows users this means we don't have a dependecy on
  .NET 2.0 any more. It's a very fast and clean install.

* Better management: We now log each incomming connection to the eventlog
  (Windows) or access.log (Mac).

* UI improvements: HiDPI support on Windows and Retina + Yosemite dark mode
  support on the Mac.

* Easy sign in UI which now supports Google 2 factor authentication. A Google
  account isn't necessary, but you can still use your existing Google account
  to sign in.

HOW TO GET STARTED

1. Install *Jump Desktop Connect* on all the machines you'd like to access:
    * [Download Jump Desktop Connect for
      PC](https://jumpdesktop.com/downloads/connect/JumpConnectInstaller.exe)
    * [Download Jump Desktop Connect for
      Mac](https://jumpdesktop.com/downloads/connect/JumpDesktopConnect.dmg)
2. After the installer is done, open up "Jump Desktop Connect" and follow the
configuration instructions.

3. Open up Jump Desktop for Mac 6.0 Beta or Jump Desktop for iOS 7.0 Beta and
sign into the same account. Existing users should sign into their Gmail
accounts so that you can see all your existing connections.

IMPORTANT COMPATIBILITY NOTE

At the moment Jump Desktop Connect _only_ supports Jump Desktop Mac 6.0 Beta
and Jump Desktop iOS 7.0 Beta. Earlier versions of Jump Desktop for
Mac/iOS/Android  will not be able to 'see'  computers that have Jump Desktop
Connect installed.

If you want to access your machines from older clients make sure you have the
current automatic setup component installed on the machine from here: [Download
Automatic Setup On Windows and Mac](https://jumpdesktop.com/go). You'll end up
having two different Jump Desktop icons on the remote computer. This is a
temporary measure until we add support for older clients to Jump Desktop
Connect.


FAQ

* *Where is the PC vewier?* Jump Desktop PC Viewer has been deprecated. We're
  going to be re-releasing an new viewer in a future update.

**Whats new in Jump Desktop for Mac 6.0**

* This release adds support for said new new cloud backend above.
* New: Filter bar. Use `⌥⌘f` to show/hide the bar. Here's a screenshot:

![](http://grab.by/H5VI)
* New: Disable SSLv2 and SSLv3 because of [Poodle Attack](https://poodle.io).
  TLS 1.0, 1.1 and 1.2 are supported.
* New: SNI support for SSL
* Fixed: Connections using SSH and RD Gateway do not work if started from
  spotlight
* Fixed: Connections' `.jump` file is edited when connection closes even if
  connection has been edited at all
* Fixed: In Edit compter window, tab key order goes haywire when user edits
  computers of diffrent protocol types (RDP/VNC)
* Fixed: Jump Mac Viewer crashes if `/` ends up in a tag name.
* Fixed: VNC: Multiple key press events may be sent to the remote server when
  arrow keys are used.
* Misc other fixes.


Version 5.0.3 Build 140
-----------------------
Released Dec 30 2014

* Fixed: An issue that caused Jump to send an extra key up event when certain
  keys like arrows were pressed
* Fixed: Extra SSL warnings shown because Jump was not parsing
  Subject-Alternative-Name in X509 certificates properly
* Fixed: An issue when parsing gateway addresses in RDP files
* New: Added Solaris icon

Version 5.0.2 Build 139
---------------------

* Fixed: Regression in 138 that caused updates to stop
* Add a few more icons

Version 5.0.2 Build 138
---------------------
Released Nov 15 2014

* Fixed: Issue where the icon view wasn't displaying custom icon images
  properly
* Fixed: White screen on Mountain Lion
* More refinement to the Yosemite screen freeze workaround
* Lots of stability and leaks fixed

Version 5.0.2 Build 137
-----------------------
Released Nov 12 2014

* A possible fix for Yosemite freeze screen issue. If you see any issues please
  report these to betasupport@jumpdesktop.com ASAP.
* Fixed: Tab does not work occasionaly while editing server configuration.


Version 5.0.2 Build 136
-----------------------
Released Nov 11 2014

* Fixed: Regression introduced in Build 133 that caused updates to stop on
  multi-mon systems which had a monitor to the left of the dock.

Version 5.0.2 Build 135
-----------------------
Released Nov 10 2014

* Fixed: Actual fix for severe drawing lag that was introduced in builds 133 &
  134 (Sorry!)


Version 5.0.2 Build 134
-----------------------
Released Nov 9 2014

* Fixed: Regression in build 133 that caused severe drawing lag for some users


Version 5.0.2 Build 133
-----------------------
Released Nov 9 2014

####Update on Yosemite Frozen Screen Bug

Thank you for your help in track down this issue. We still haven't been able to
zero in on this but here’s what we know so far (again thanks to your continued
feedback):

  1. We suspect that this might be a OpenGL graphics driver bug that affects
  Macs with NVIDIA cards only.
  2. This happens in fullscreen AND windowed mode (previously we though that
  was a fullscreen issue only).
  3. There is a chance that this is fixed in Yosemite 10.10.1 Beta.

What you can do to help: If you suspect any thing at all, report it to
betasupport@jumpdesktop.com with your logs (Help -> Diagnostic Logs). Every
report you send in helps us learn more about the problem.

####Whats new in this build

* New: Support for TextExpander (and other text injection productivity tools)
* New: Drawing optimizations: General drawing optimizations and optimizations
  for multi-monitor fullscreen mode on Mavericks and Yosemite. We've eliminated
  redraws by up to 2x for multimonitor to 3x for triple monitors.
* New: Add more icons to the icon library. To customize your computer's icon
  edit your computer and click the icon on the to left hand corner.
* Fixed: Multi-monitor fullscreen sessions are not aligned correctly after the
  Mac is unlocked

Version 5.0.2 Build 132
-----------------------
Released Oct 29 2014

* Critical Fix: Crash on start on 10.8 and 10.9


Version 5.0.2 Build 131
-----------------------
Released Oct 29 2014

* New: Configurable icons for servers. You can now customize icons for your
  servers. Edit your server settings and then click on the icon button on the
  top left. We're shipping with 20+ icons (including a tux icon!). Note: At
  this time you can't use your own icon -
just what's in our library.
* Fixed: Lock Screen option is not persisted between sessions
* Fixed: Tags could not be rearranged in the sidebar
* Fixed: Command + Control + H does is incorrectly translated to Ctrl + Alt +
  Delete on Windows
* Fixed: An issue where going fullscreen shows textured bars on Mountain Lion
  and Mavericks
* Fixed: Extra dead space in the toolbar
* Fixed: Drawing alignment issues
* Fixed: Crash when waking up and trying to reconnect to an automatic
  connection
* Fixed: Other stability fixes


Version 5.0.1 Build 130
-----------------------

* Remove focus ring from outline view sidebar (10.8 and 10.9 drew this, but
  10.10 avoided it)


Version 5.0.1 Build 129
-----------------------

This is a web release only.

* Fixed: "Buy now" title bar was overlapping the window on Yosemite. We've
  fixed it by making sure the top title bar remains visible if we're in trial
  mode.

Version 5.0.1 Build 128
----------------------

* No code changes -
increment build # to appease iTunes Connect


Version 5.0.1 Build 127
---------------------
Released Oct 18 2014

* Fixed: Jump hangs when there are lots of discovered computers
* Fixed: Crash when dragging Tags
* Fixed: Mouse Cursor updates checkbox was not correctly set and caused cursor
  updates to stop working after editing a server


Version 5.0 Build 124
---------------------
Released Oct 15 2014

This is the final release of Jump Desktop for Mac 5.0. **If you see any
problems please report it ASAP.** You can either reply to this email or create
a post at the [beta testers'
forum](https://rink.hockeyapp.net/manage/apps/2848/feedback/new) or mail us at
betasupport@jumpdesktop.com. Thank you for beta testing Jump Desktop for Mac.

* Fixed: Attempt to fix an elusive crash with automatic connections

Version 5.0 Build 123
---------------------
Released Oct 14 2014

We need your help: **We're trying to track down an elusive crash with automatic
connections**: If you have automatic connections configured in Jump Desktop and
you frequently experience Jump Desktop crashing when resuming you Mac from
sleep please contact betasupport@jumpdesktop.com . We haven't been able to
reproduce the crash on our end but we do know some users have reported this
type of crash. Any details you can provide about your configuration would be
super helpful.

* Fixed: An issue with Cmd + Tab handlng which caused the start menu to popup
* Fixed: Crashes on OSX 10.9.5 (regression in Build 122)


Version 5.0 Build 122
---------------------
Released Oct 13 2014

We need your help: **We're trying to track down an elusive crash with automatic
connections**: If you have automatic connections configured in Jump Desktop and
you frequently experience Jump Desktop crashing when resuming you Mac from
sleep please contact betasupport@jumpdesktop.com . We haven't been able to
reproduce the crash on our end but we do know some users have reported this
type of crash. Any details you can provide about your configuration would be
super helpful.

Whats new in this release:

* Critical Fix: Printing to the Jump Desktop Printer does not work correctly
* Critical Fix: Repeated crashes on 10.8
* New: Add an option to lock the remote screen when connecting to OS X remotes
* New: Add Cmd+s keyboard shortcut to save temporary auto discovered (Bonjour)
  computers
* New: Add save button to save temporary auto discovered (Bonjour) computers in
  icon view
* New: Few minor UI tweaks
* Fixed: Cmd + Tab sporadically causes the 'Start' menu to appear on Windows
  machines.
* Stability fixes

Version 5.0 Build 121
---------------------
Released Oct 10 2014

Note: This is the final release of Jump Desktop for Mac 5.0 (baring any
critical issues). **If you see any problems please report it ASAP.** You can
either reply to this email or create a post at the [beta testers'
forum](https://rink.hockeyapp.net/manage/apps/2848/feedback/new) or mail us at
betasupport@jumpdesktop.com. Thank you for beta testing Jump Desktop for Mac.

* New: The minimum required version of OS X is now 10.8
* New: UI refresh for the icon view with a Yosemite inspired theme
* Fixed: Servers were not deleted correctly (regression in build 119)

Version 5.0 Build 120
---------------------
Released Oct 9 2014

* Critical Fix: Crash during startup. Please read on for whats new in build
  119.


Version 5.0 Build 119
---------------------
Released Oct 9 2014

Note: The final release of Jump Desktop for Mac is just around the corner. **If
you see any problems please report ASAP.** You can either reply to this email
or create a post at [beta testers'
forum](https://rink.hockeyapp.net/manage/apps/2848/feedback/new) or mail us at
betasupport@jumpdesktop.com.

* **Very important critical fix for beta testers running JVM Builds 114 to
  118**: If you were using Jump Desktop for Mac beta builds 114 (released 22nd
  August onwards) through 118 and you submitted your diagnostic logs for a RDP
  connection: Your Windows password may have been accidentally submitted in the
  logs. Please change your Windows password immediately. We will be
  individually emailing all beta testers who we think may have been sent us
  logs from RDP connections on these builds. We're extremely sorry about this.
  If you did not submit your RDP logs on builds 114 through 118 then you are
  not affected by this issue. Please email betasupport@jumpdesktop.com if you
  have any questions about this.

* New: RDP: Add support for 32bit color depth
* New: VNC: Remember the last display that Jump was connected to for OS X
  connections
* New: VNC: Show the display number in the HUD display when in fullscreen mode
* New: VNC: Latency reduction on automatic connections when connecting to OS X
  machines. This fix dramatically reduces the update latency on automatic
  connections. However it may slow down update speeds on very fast networks
  (i.e. automatic connections on the local network). We've added a new quality
  option for OS X VNC connections called 'High Bandwidth Mode' that you can
  enable if you want to manually revert to the old behaviour.
* New: 'Fit to screen' in windowed mode now enforces the aspect ratio of the
  window frame (no more black bars)
* Fixed: Mac auto-clipboard syncing always overwrites the remote clipboard with
  the local clipboard.
* Fixed: Very slow startup times on build 117 and 118
* Fixed: Fullscreen on all monitors does not work on Yosemite
* Fixed: RDP: Printing fails on Yosemite
* Fixed: RDP: Increase RDP scroll wheel speed
* Fixed: RDP: Pressing Cmd + Tab locally causes the Win key to be sent to the
  remote
* Fixed: RDP: Increase redirection PDU packet buffers -
the was causing
  connections to fail on some load balanced TS gateway farms

Version 5.0 Build 118
---------------------
Released Oct 3 2014

Note: Final release of Jump Desktop for Mac is just around the corner. **If you
see any problems please report ASAP.** You can either reply to this email or
create a post at [beta testers'
forum](https://rink.hockeyapp.net/manage/apps/2848/feedback/new) or mail us at
betasupport@jumpdesktop.com.

* New: Icon View can be navigated with keyboard. User arrow keys and shift key
  to change selection
* New: Use Cmd+i, enter key and, backspace and delete key shortcuts in Icon
  View
* New: Access keychain only when user edits a computer or launches it. This
  improves the app startup time
* New: Remove .jump files of duplicate automatic computers. This fixes few rare
  bugs
* Bug fix: Sidebar keeps getting smaller everytime a sidebar row is selected
* Bug fix: Last remaining tag is not removed from sidebar until app is
  restarted
* Bug fix: Dropping a tag into a tag tree that already has a similar tag
  rearranges the sidebar tag tree

Version 5.0 Build 117
---------------------
Released Sep 30 2014

* Critical fix: Fixes Gmail login problem in the previous build (116). To the
  beta testers affected by this: We're really very sorry about this!

Version 5.0 Build 116
---------------------
Released Sep 29 2014

* New: Yosemite fixes
* New: Press Cmd+i to edit a computer
* New: Press enter key to launch computer
* New: Press backspace or delete to remove computer from the list
* New: Sidebar is visible by default on new installations
* Bug fix: Several fixes to JumpSDK
* Bug fix: Remove duplicate Automatic Computers from the list
* Bug fix: When a tag is renamed all collapsed tags are expanded
* Bug fix: Tag selection is not maintained when a new tag is added
* Bug fix: Username is not stored and reverts back to old value randomly
* Bug fix: Two Bonjour service related crashes that happen due to race
  condition
* Bug fix: Sidebar width is not maintained when it is hidden and then displayed
  afterwards
* Bug fix: When a tag is dragged and dropped in the sidebar, tag selection
  changes but computers list doesn't reflect this change

Version 5.0 Build 115
---------------------

* Yosemite fixes
* Fixes to JumpSDK

Version 4.1 Build 114
---------------------

* New: Show tag count in the sidebar

  ![Screenshot of tag count](http://i.imgur.com/0IoLQga.png)

* New: Option to search and add new tags

  ![Screenshot of search field and add new tag
  button](http://i.imgur.com/K3MLm23.png)

* New: Bulk edit computers

  ![Screenshot of edit computers with a tag](http://i.imgur.com/o2qmbao.png)

  ![Screenshot of edit multiple computers](http://i.imgur.com/SvZ1YEj.png)

* New: Restore collapse/expand status of tags folder when application is
  restarted
* New: Collapsed tag is a union of itself and its child tags

  ![Screenshot of tag count](http://i.imgur.com/0IoLQga.png)

  ![Screenshot of collapsed tag](http://i.imgur.com/M6W1lmG.png)

* New: Move "Discovered" button from toolbar to the sidebar

  ![Screenshot of Discovered](http://i.imgur.com/POdLSZe.png)

* New: Add menu item to remove tag in the context menu

  ![Screenshot of remove a tag](http://i.imgur.com/iu1s1Y0.png) ![Screenshot of
  remove tags](http://i.imgur.com/gpkdQhB.png)

* New: Drag and drop computers onto "Computers" in the sidebar to remove all
  tags
* New: Option to disable switching spaces automatically when in full-screen on
  multiple monitors
* Bug fix: Ordering tags in the sidebar does not always work
* Bug fix: Application crashes when a tag is dropped onto a collapsed tag in
  the sidebar
* Bug fix: Welcome Screen is not displayed in a particular case
* Bug fix: Show/Hide Sidebar menu item has incorrect title
* Bug fix: Yosemite: Code-signing problems
* Bug fix: Yosemite: RDP connections in fullscreen mode were disconnected when
  switching spaces

Version 4.1 Build 113
---------------------

This update has two most requested features.

1. Nested Tags to organize computers into folders
1. Auto Discover computers in the network

We need your feedback to make Jump Desktop even better. Please spare a moment
and reply to this email to share your thoughts about the enhancements.

## Nested Tags

* You can have nested tags to organize your computers into *folders*

  ![Screenshot of nested tags](http://i.imgur.com/WVq3WUl.png)

* Add nested tags using forward slash '/', for example "Home/Auto Detected"

  ![Screenshot of tags field in edit window](http://i.imgur.com/vUE3uI6.png)

* Drag and drop tags in the sidebar to rearrange them

  ![Screenshot of rearranged tags](http://i.imgur.com/pkhDp3W.png)

* Edit tags directly in the sidebar. "Tags View" has been removed

  ![Screenshot of tag context menu](http://i.imgur.com/2bFS9C1.png)

* Rename a tag by double clicking on it

  ![Screenshot of rename a tag](http://i.imgur.com/9IgqyM2.png)

* Drag computers onto a tag in the sidebar to assign the tag to it
* Do a multiple selection of computers and drag the selection onto a tag to do
  a bulk assignment
* Drag a tag out of sidebar to delete it
* All tags now appear in the sidebar. "Pinned Tags" has been removed

## Leverage Bonjour to Auto Discover Computers

* Auto discover computers in the network and let user connect to them without
  having to configure anything

![Screenshot of Bonjour button](http://i.imgur.com/u9SCKh9.png)

* Click on "Discover" button to hide and unhide discovered computers

![Screenshot of disabled Bonjour button](http://i.imgur.com/VE6fLSK.png)

* Auto discovered computers can be saved permanently to the user Computer's
  list

![Screenshot of context menu of auto discovered
computers](http://i.imgur.com/arXWxJ0.png)

## Other Changes

* New: Search result does not get reset when user adds new computer
* New: Bug fixes and performance updates to automatic connection backend
* New: VNC: Support for VNC TLS authentication -
Ubuntu 14.04 requires this out
  of the box
* [FIXED] In some cases, Sync settings' "Choose Folder" window does not appear
* [FIXED] Auto-complete in Add New Computer window interferes when user edits
  the field

# We need your help

What do you think about the new features? How can we make it better? Notice any
bugs? Is the "Discover" button confusing? Is the count bubble on Discover
button any helpful?

These are few of the questions that we need answered. Please reply to this
email to share your answers with us.

Version 4.1 Build 111
---------------------

* New: VNC: Ability to select individual Displays when connection to Macs with
  multiple monitors. When connected to a multi-mon Mac click Remote ->
  Displays.
* New: VNC: Explicit "Send Pasteboard" menu option when connecting to Macs that
  sends the entire contents of the pasteboard including images (by default
  automatic pasteboard syncing only syncs text)
* Fixed: Regression in build 110 that caused a crash when adding servers

Version 4.1 Build 110
---------------------

* New: Initial draft of Jump SDK. Third party apps can use the SDK to open RDP
  virtual channels. For more information and examples: [Jump Desktop for Mac
  SDK](http://github.com/phasefivesystems)
* New: VNC: Quality options when connecting to Macs. Select Low to reduce
  bandwidth usage by up to 70% on Retina Macs. Note: We're still fine tuning
  these settings
* New: VNC: Pasteboard support for Macs. Pasteboard FROM your computer to the
  Remote Mac is automatically synced. However you will need to manual request
  the pasteboard FROM the Remote Mac by clicking Remote -> Get Mac Pasteboard
* New: Rendering performance optimizations specially for Macs

Version 4.0.4 Build 102
-----------------------
* Fixed: An issue for MAS users when printing to the Jump Desktop Printer

Version 4.0.3 Build 101
-----------------------
* Fixed: A crash during dictation
* Fixed: A crash when changing sync settings

Version 4.0.2 Build 100
----------------------
* Fixed: Spelling error in General preferences
* Fixed: TS Gateway connections cause Jump to crash on the first run after an
  upgrade  from 3.0.7
* Fixed: TS Gateway credentials may not be passed correctly to servers
* Fixed: Possible Crash when removing a SSH connection

Version 4.0.1 Build 99
----------------------
* Fixed: 10.6 only: Google login failed
* Fixed: RDP: Icelandic and European keyboards
* Fixed: Don't show the current computer in the list of computers
* New: Add option to hide HUD Display
* Fixed: Jump reconnected to existing sessions on MacBook Pro when it switched
  between discreet and integrated graphics adapters
* Fixed: "Jump Desktop Printer" reported error '9' when during printing

Version 4.0 Build 98
--------------------

* Fixed: Jump does not automatically dismiss the trial dialog if it is not
  already running and the user double clicks a "jdlicense" file. This causes
  user confusion.


Version 4.0 Build 97
--------------------

* Fixed: Tab ordering for gateway controller
* Changed default TS gateway name to "RD Gateway" so that it's more consistent
  with other ui



Version 4.0 Build 96
--------------------

This is the final 4.0 build. In case you see any issues please contact us ASAP
and we'll look into it. You can reply to this email or send mail at
betasupport@jumpdesktop.com.

* Fixed: Screen stops updating after resizing a remote Mac's desktop


Version 4.0 Build 95
--------------------

This is the final 4.0 build. In case you see any issues please contact us ASAP
and we'll look into it. You can reply to this email or send mail at
betasupport@jumpdesktop.com.

* Fixed: A bug that was affecting Sync feature for some users
* Fixed: Confusing text of warning message when user changes Sync service

Version 4.0 Build 94
--------------------

This is the final 4.0 build. In case you see any issues please contact us ASAP
and we'll look into it. You can reply to this email or send mail at
betasupport@jumpdesktop.com.

4.0 will be one of our best releases thanks to your suggestions, feedback and
bug reports. Thank you very much for helping beta test Jump Desktop!

Changes:

* New: Updated cryptography libraries
* Search in "Tags" view is case insensitive
* Fixed: A bug that does not let some users remove tags from sidebar
* Fixed: Clipboard was not synchronized properly when starting a connection in
  Windowed mode
* Fixed: Crash when disconnecting on 10.6 and 10.7
* Fixed: Keyboard shortcuts were not working on 10.6
* Fixed: VNC: Updates were slow on headless Mac machines
* Fixed: RDP: Verify the entire SSL certificate chain when checking SSL
  certificates vs only the leaf. This caused certificate validation to fail if
  intermediary certificates were used

Version 4.0 Build 93
--------------------

Note: We are very close to releasing 4.0. If you have any issues or feedback
for the build please do not hesitate to contact us. You can reply to this email
or send mail at betasupport@jumpdesktop.com. Thank you for helping beta test
Jump Desktop.

* New: HUD of the server name when switching between fullscreen connections
* Reduce fullscreen transitions when reconnecting on 10.7 and later
* Changes to the way we bring fullscreen multi-monitor connections to the front
* New: Add a new menu item to enable / disable Mac OS Shortcuts while connected
  to a remove. Use Control + Command + Left Arrow to toggle via keyboard
* More Mavericks focused power and memory consumption improvements
* New: Option to import servers stored in old archive file. Click on File ->
  Import in the top menu bar
* Fixed: Screen may look pixilated for some connections
* Fixed: Jump does not go into fullscreen mode when "Use All Monitors" was
  selected
* Fixed: Mavericks only: Jump connections search results were categorized under
  'other' in Spotlight. We've fixed it to make results appear at top of
  Spotlight results. Please note: You may need to force Spotlight into
  re-indexing your Jump files by editing each file manually in Jump or if
  you're comfortable with Terminal.app use the following command to reindex
  your Servers directory: `touch ~/Documents/JumpDesktop/Viewer/Servers/*`

Version 4.0 Build 92
--------------------

* RDP: Re-add support for 3.x driver-based printing in addition to driverless
  printing (also called "Jump Desktop Printer"). The 3.x printer driver is
  optional but offers up to 5x performance and bandwidth savings when compared
  to driverless printing.
* VNC: Fix an issue in the Tight encoder's JPEG handling which caused screen
  updates to stop when connected to Tiger VNC
* VNC: Prefer ZRLE encoding over Tight encoding because most VNC servers have a
  fairly slow implementation of Tight encoding.
* New: Multi-monitor full screen mode now works with Maverick's "Displays have
  separate spaces" option.
* New: Full screen multi-monitor options can now be changed while connected to
  a remote (View menu -> Use All Displays)
* New: More power focused optimizations
* New: Added the ability to file shortcuts/aliases for a connection: Right
  click the connection and click "Create Alias".
* New: Revamp welcome screen
* New: Change `google` search keyword to `auto`
* New: Search tool tip has increased readability
* New: Add "Don't show again" button to tool tip
* Fix: Crash on 10.6
* Fix: Connections should not be saved when opening .RDP files
* Fix: Rendering issues
* Fix: Add 5900 to VNC display numbers automatically
* Fix: `rdp` search keyword shows some irrelevant results
* Fix: Cmd+w keyboard shortcut does not close Preferences window
* Fix: Pressing `/` or `?` will not focus search box in list view
* Fix: Sort button in tags list is missing its left border
* Keyboard shortcut to switch between list and icon view has been removed

Version 4.0 Build 91
--------------------

* Critical Fix: RDP: Random disconnects when connecting to Windows 7 and later
  machines
* New: Reorder Pinned Tags in the sidebar by dragging
* New: Improve icon view's scrolling performance
* New: Updated app icon -
the new icon is 10% smaller and is a better fit in
  the dock
* New: SSH and TS Gateway columns are now available in list view mode
* New: Improved support for international characters in keyboard mapping
  preferences: Copy paste and characters that required dead keys are supported.
  Also added more key presses in drop down.
* New: Added new per-server option to swap mouse buttons
* Fix: Jump doesn't open up connections launched from Spotlight
* Fix: Jump doesn't read TS Gateway connection information from RDP files
* Fix: New RSA keys for SSH servers were not stored correctly when 'Accept' was
  pressed.
* Fix: More logging for SSH connections
* Fix: RDP: Scroll wheels on physical mice required 3-4 wheel turns before
  scrolling started
* Fix: RDP: Mouse pointer does not show up correctly when connecting to Windows
  8 RDP in HDPI mode
* Fix: Unable to see the menu bar when JD was launched in the same space as the
  computer window
* Fix: Mavericks: Menu bar was not hidden when launching a connection in full
  screen mode on secondary monitor and other fullscreen fixes
* Fix: Can not get out of fullscreen after maximizing the screen
* Fix: RDP: JVM: Copy pasting from MS Access 2013 to Excel on Mac looses
  formatting
* Fix: RDP: Disconnecting a RDP remote control session causes Jump to crash
* Fix: Mac dictation was not working correctly

Version 4.0 Build 90
--------------------

* New: Reorder Pinned Tags in the sidebar by dragging
* New: Improve icon view's scrolling performance
* New: Updated app icon -
the new icon is 10% smaller and is a better fit in
  the dock
* New: SSH and TS Gateway columns are now available in list view mode
* New: Improved support for international characters in keyboard mapping
  preferences: Copy paste and characters that required dead keys are supported.
  Also added more key presses in drop down.
* New: Added new per-server option to swap mouse buttons
* Fix: Jump doesn't open up connections launched from Spotlight
* Fix: Jump doesn't read TS Gateway connection information from RDP files
* Fix: New RSA keys for SSH servers were not stored correctly when 'Accept' was
  pressed.
* Fix: More logging for SSH connections
* Fix: RDP: Scroll wheels on physical mice required 3-4 wheel turns before
  scrolling started
* Fix: RDP: Mouse pointer does not show up correctly when connecting to Windows
  8 RDP in HDPI mode
 * Fix: Unable to see the menu bar when JD was launched in the same space as
   the computer window
* Fix: Mavericks: Menu bar was not hidden when launching a connection in full
  screen mode on secondary monitor and other fullscreen fixes
* Fix: Can not get out of fullscreen after maximizing the screen
* Fix: RDP: JVM: Copy pasting from MS Access 2013 to Excel on Mac looses
  formatting
* Fix: RDP: Disconnecting a RDP remote control session causes Jump to crash
* Fix: Mac dictation was not working correctly

Version 4.0 Build 89
--------------------
* RDP: Re-added "Jump Desktop Printer" to the list of printers. Printing to
  this printer will open up the page in the 'Preview' app just like 3.0.
* RDP: Bug fixes to RDP file redirection
* RDP: Printing: Crash when there were too many printers connected to a Mac
* RDP: RD Gateway: International characters in computer names cause login to
  fail when connecting Server 2008 SP2
* UI: Resizeable sidebar
* UI: "Show computers" options added to tags' view
* UI: Go button from tags removed. Double click on tags to see computers
* UI: Color and style of icons is more in line with Mavericks design
* Fix: Tune startup performance when there were lots of servers (1000+)
* Fix: Performance and memory consumption improvements when in icon view
* Fix: Automatic connections fail to connect sometimes -
requires multiple
  connection attempts to connect
* Fix: UI polishing
* Fix: When importing a RDP file, use the file's name as the display name
  instead of the host/IP address
* Fix: Be more aggressive when trying to reconnect to automatic connection
  computers
* Fix: Performance improvement when a tag is renamed or edited

**Please** share your feedback and suggestions about UI and style. Reply to
this email with your comments.


Version 4.0 Build 88
--------------------
* RDP: File redirection fixes and more logging. Possible fix for 'Access
  Denied' errors for some users
* Improved Crash Reporting
* Fix: Enable 32-bit builds for 10.6.8 users
* Fix: Keyboard Conversion menu had blank keys in the drop down
* Fix: List view sort order is not restored on restarting the app
* Fix: Crashes on OSX 10.6 and 10.7

Version 4.0 Build 87
--------------------

* Critical Fix: New computers cannot be added
* Fix: Bug in rendering engine that caused glitches on the screen
* Fix: Energy optimizations for OSX 10.8 and lower
* Fix: Server redirection fails when FIPS encryption is used
* Fix: Cannot rename computer or add tags to it
* Fix: Crashes

Version 4.0 Build 85
--------------------

* Critical Fix: RDP connections were not connecting
* New: Rendering engine thats optimized for speed and efficiency
    * Uses less memory and lowers screen update latency
* New: Energy Saving features on OS X 10.9 Mavericks
    * Jump automatically turns off screen updates and goes into low power mode
      when a remote session	 is not in use.
    * Numerous energy saving improvements throughout the code base. This is the
      most energy efficient version of Jump we've ever released.
* New: RDP: Printer redirection engine improvements
    * Does not require Jump Desktop Printer Driver to be installed on the
      target machine.
    * All printers connected to the Mac are automatically shared with the
      remote.
* New: RDP: Audio redirection support improvements
    * Lower latency and more energy efficient than previous versions
* New: Full screen on all displays in new space
    * On multi-monitor systems Jump can now create a new space while using all
      monitors. Previously it couldn't create a new space and forced you to use
      the same space.
    * If you're on 10.7 and later with multi monitors, just go full screen and
      you'll notice Jump creates a new space.
* New: 64 bit version
* New: Retina icons on main window
* New: A simpler and straight forward Sync Options UI
* New: Option in Sync UI to get rid of duplicate computers
* New: iCloud Sync support (this is currently disabled in the Beta due to
  Apple's restrictions)
* Fixed: RDP: Folder redirection takes time to show up on the remote machine
* Fixed: Dock and Menu bar sporadically disappear from Jump's main window.
* Fixed: 10.6 compatibility problems
* Fixed: Sync issues with Dropbox

Version 4.0 Build 84
--------------------

* New: Rendering engine that is optimized for speed and efficiency
* New: Energy Saving feature of OS X 10.9 Mavericks
* New: 64 bit version
* New: Retina icons on main window
* A simpler and straight forward Sync Options UI
* Option in Sync UI to get rid of duplicate computers
* Fix crashes and bugs

** Important! Please Read ** Some users have reported that they cannot connect
to their Win7 machines via RDP protocol. We need more logs and user reports to
reproduce and fix this issue on our end.  If you face this problem, please send
logs and information about your setup to us. Meanwhile you can download and
keep running [Version 4.0 Build
83](https://rink.hockeyapp.net/manage/apps/2848/app_versions/73) for your day
to day tasks.

Version 4.0 Build 83
--------------------

* Bug fix: Keyboard layout issues
* Bug fix: When a pinned tag is clicked in the sidebar, show only those
  computers which have that exact tag ### Search
* Search for exact word if it is enclosed in quotes, for example,
    - `"PC at Home"` this will exclude computers with similar names like "PC at
      Home (Dad)" from results
    - `Tag:"Production Servers"` this will exclude tags with similar names like
      "Production Servers New" from results
* Perform boolean AND search if any of the search term is enclosed in quotes
    - `Tag:"Production Servers" AWS` this will display computers that have tag
      "Production Servers" AND AWS tag
    - `"PC at Home" RDP` this will display computers whose display name is a
      exact match of "PC at Home" and use RDP protocol or tag

Version 3.6. Build 82
---------------------

* Critical fix: Tcp ports were not being read correctly (defaulted to VNC 5900)


Version 3.6 Build 81
--------------------

* **OSX 10.6 support** OSX 10.6 users please update to this version
* Fix: Display settings of computer will not save
* Fix: Editing display name of computer crash the application some cases
* Fix: Single click on Path UI in Sync preferences was not effective
* Fix: Spotlight importer was no longer working
* Fix: 10.6 specific bug that will keep truncating name of computer in UI

Version 3.6 Build 79
--------------------

* **Import and export computers** Click on File menu to access Import and
  Export options
* **Set custom folder** where .jump files are stored. Got to Preferences and
  click on Sync to set the location
* **Sync** Store .jump files in Dropbox to sync your computers across your Mac
  computers
* Add menu items and keyboard shortcut Cmd+1 and Cmd+2 to switch between icon
  and list view
* Add Break, Scroll Lock and Pause to the list of key mappings
* Auto reconnect if connection to Google account gets disconnected
* Fix: Sidebar cannot be hidden
* Note: This release does **NOT fix OSX 10.6** compatibility issues. OSX 10.6
  users please do not update to this release
* Note: iCloud sync is not supported in this release

Version 3.5 Build 76
--------------------

Release 5th August 2013

* Spotlight support: Now you can search for your computers using spotlight
* Search for computer in spotlight using their tags, display name, hostname,
  protocol type, connection type etc
* List view: User can keyboard navigate the list, perform multiple selection
  and launch connection by pressing enter key
* User can sort list by clicking on list headers
* User can show and hide columns
* Store each server in separate `.jump` files
* Set SSH servers display name in preferences window
* Sort SSH servers list by their display name in preferences Window
* Change user visible label of passwords stored in the Keychain
* Show port of SSH server in the selection list in edit window
* RDP: Fix a bug that causes modifiers state to go out of sync
* RDP: Add API to set forward secrecy ciphers only
* SSL: Prefer AES256+ECDHE for encryption
* Fix: Tab key press will not focus on next text field in add new connection
  window
* Fix: Do not perform autocomplete in quick connection or add new connection
  window when user presses `.` key
* Fix: Duplicate connections are not saved
* Fix: RD Gateway settings are not updated

Version 3.0.5 Build 75
----------------------
Released 25th April 2013

* Critical fix: RDP: Fixes a regression introduced in 3.0.3 that caused the
  screen to not update properly when connecting to Server 2003, Server 2008 and
  XP

Version 3.0.4 Build 74
----------------------
Released 23rd April 2013

* Fixed: Trial version banner does not go away after importing a license
* Fixed: Occasional rendering artifacts
* Fixed: 'Fullscreen on all displays' may sometimes not hide the dock

Version 3.0.3 Build 73
----------------------
Released 22nd April 2013

* Fixed an issue with the trial license where the user wasn't able to connect
  to a server during the trial


Version 3.0.2 Build 72
----------------------
Released 21st April 2013

* Stability fixes: Fixes for top 5 crashes
* RDP: Minor rendering fix
* VNC: Adds support for 24bit color mode


Version 3.0.1 Build 71
--------------------
Released 4th April 2013

* Fixed: 'Server Redirection' checkbox in RDP settings was not working
* Fixed: 'Name / Count' switch was cut off at the right

Version 3.0 Build 70
--------------------
Released 2nd April 2013

* Possible fix for crash when closing a RDP connection with audio playback
  enabled


Version 3.0 Build 69
--------------------
Released 1st April 2013

We're very close to releasing 3.0! If you see any bugs or have suggestions
please contact betasupport@jumpdesktop.com immediately!

* Critical Bug Fix: RDP: RD Gateway with RD session redirection enabled cause
  Jump to fail with either a silent disconnection or E_PROXY_RAP_ACCESSDENIED
  (0x800759DA).
* RDP: Jump was not using the correct name when verifying SSL certificates for
  redirected sessions. This resulted in Jump showing excessive server
  certificate validation warnings.
* Fixed tab ordering in the RD Gateway management screen and make sure to parse
  out usernames of type "domain\username" properly.


Version 3.0 Build 68
--------------------
Released 30 March 2013

We're very close to releasing 3.0! If you see any bugs or have suggestions
please contact betasupport@jumpdesktop.com immediately!

* Fixed: RDP: Fixes a disconnection issue on Windows 8 and Windows 2012
* Fixed: Reconnecting in fullscreen mode caused the display to appear scrambled
* Minor UI polish

Version 3.0 Build 67
--------------------
Released 29 March 2013

We're very close to releasing 3.0! If you have any bugs or suggestions please
contact us immediately!

* Fixed: RDP: Mouse cursor updates on Server 2012 were not working
* Fixed: Computer row is not selected when a new computer is added


Version 3.0 Build 66
--------------------
Released 28 March 2013

* New: Automatic reconnect: Jump automatically reconnects to existing sessions
  when the Mac wakes up or when there are networking problems
* New: More robust and quicker detection of dropped connections
* New: Jump automatically reconfigures existing RDP connections running in
  multi-monitor mode when a display is added or removed
* New: RD Gateways can now be renamed by clicking the name their name in the
  list view
* New: Sidebar animations when toggling the sidebar
* New: Option to ignore RDP certificate errors (in the Advanced server
  settings)
* Fixed: Tags were not being renamed properly
* Fixed: Jump doesn't show a prompt to reconnect to Gmail if you get
  disconnected (it automatically reconnects)
* Fixed: Send Keys -> Insert was not enabled when connected to remote sessions
* Fixed: Jump crashes on 10.6

####Known issues with the current beta:
* RDP: Mouse cursor updates on Server 2012 sporadically stop working

Version 3.0 Build 65
--------------------
Released 25 March 2013

* Critical Fix: Slow startup and CPU usage spikes when saving server contacts

####Known issues with the current beta:
* RDP: Mouse cursor updates on Server 2012 sporadically stop working
* Jump does not start up on Mac OS X 10.6


Version 3.0 Build 64
--------------------
Released 21 March 2013

* New: RDP: Support for multi-monitor RDP sessions. Select the 'Fullscreen on
  all displays' option in the 'Display' section: ![](http://grab.by/kVS6)
* New: RDP: Belgian French keyboard added to RDP
* New: Send key menu now has an 'Insert' button
* Fixed: RDP: Copy/paste stopped working in some apps
* Fixed: RDP: Italian keyboard wasn't being detected in the 'Match Mac
  Keyboard' settings


Version 3.0 Build 63
--------------------
Released 20 March 2013

###New feature: Tags and Sidebar ![](http://grab.by/kS68)

* You can assign tags to your computers. Go to settings window of the computer
  and add tags in the tag's field ![](http://grab.by/kS6k)

* Tags list support auto complete so it will show you a list of suggestions
  from your previously entered tags
* You can edit and view all tags by clicking on `Tags` in the sidebar
* In tags view you can see tags along with the count -
number of computers that
  are tagged with it
* Tags list can be sorted by name and count
* Tag can be renamed, removed from all computers and deleted
* Hover on a tag, click on the go button that appears and it will show the
  computers that are tagged with it
* To rename a tag, select it twice with a little delay, just like Finder
* You can do multiple selection of tags too. Just press ⌘ key and click on tags
  to do multiple selection
* With multi selected tags, you do bulk removal, delete, pin operation and view
  computers
* You can pin a tag to the sidebar
* You can remove a tag from the sidebar by right click on it in the tags view
  or sidebar
* Sidebar can be hidden and shown with a simple shortcut ⌥⌘S
* Search for keywords by using `Tag:` keyword in the main search field

#####Others
* New: Perform exact searches by enclosing the query in double quotes, for
  example, "Lab 101"
* New: Search results are shown in "Search Results" view. You can click on
  Computers or clear the search field to see all your computers again


Version 3.0 Build 62
--------------------
Released 16 March 2013

* Fixed: Make sure Jump parses RDP TS consent messages properly


Version 3.0 Build 61
--------------------
Released 15 March 2013

* RD Gateway bug fixes:
    * Large server certificates caused Jump to disconnect without warning
    * Better error reporting when things go wrong
    * SSL certificates were not compared correctly
* New beta icon to help tell apart beta and public releases:

![](http://grab.by/kK3k)


Version 3.0 Build 60
--------------------
Note to testers: 3.0 is a work in
progress. We'll be releasing new features as we go along -
i.e. tagging and
grouping support will be added shortly to the next build (we're polishing this
off). In the meantime the big new feature in this beta release is TS Gateway
support for RDP.

As always send feedback/bug reports/suggestions/flame to
betasupport@jumpdesktop.com!

Thank you for beta testing Jump Desktop!

* New: RDP: Terminal Services Gateway support. Manual connections now have a
  'RD Gateway' option.  ![](http://grab.by/kyUc)
* New: More fullscreen options: Ability to select the pre 1.x fullscreen mode
  and ability to hide top menu bar in fullscreen.
* New: Options to disable mouse pointer updates in the UI.
* New: Auto complete feature for new and quick connection
* New: Auto selects user's last selected connection type in new and quick
  connection window
* New: Shows recent connections in file menu
* New: Shows quick connect, recent connections and all online computers in dock
  menu
* New: Perform exact searches by enclosing the query in double quotes, for
  example, "Lab 101"
* New: Search results are shown in "Search Results" view. You can click on
  Computers or clear the search field to see all your computers again
* Fixes: A bug that showed incorrect instruction when user clicks on offline
  Google connections
* Fixes: Increase width of SSH connections list for longer hostnames
* Fixes: Adds description for quick connection

Version 2.5 Build 51
--------------------
Released 23 Jan 2013

* New: Add support for SSH Private Key authentication
* Fixed: RDP: Drive Redirection does not work on certain Windows Server 2003
  machines
* Fixed: RDP: Modifier state may reset when a modifier key is held for a long
  time
* Fixed: Setting button did not appear on offline Gmail connections
* Fixed: The fade in/out animation of setting and connect wasn't synchronized
* Fixed: Setting button position


Version 2.5 Build 50
--------------------
Released 18 Jan 2013

* Critical Fix: Print Redirection fails on large printouts
* Critical Fix: App Store Version Only: Drive redirection fails due to Sandbox
  restrictions after restarting the app


Version 2.5 Build 49
--------------------
Released 17 Jan 2013

* Fixed: RDP Drive Redirection: Stability fixes when reading and writing large
  chunks of data
* Fixed: RDP: Show recovery options incase a Windows License expires or is
  corrupted
* Fixed: RDP: Logging off from Windows Server 2003 and 2008 will no longer show
  the 'Reconnect / Retry' dialog


Version 2.5 Build 48
--------------------
Released 15 Jan 2013

* New: Full screen button in the main window
* New: Updated images for toolbar and settings
* Fixed: RDP Drive Redirection: Unicode characters were not being handled
  properly when enumerating directories
* Fixed: RDP Drive Redirection: Fixed free space calculations
* Fixed: RDP Scroll wheel was not working properly in some applications
* Fixed: Newly created connections could not be launched


Version 2.5 Build 47
--------------------
Released 12 Jan 2013

* Critical fix: Crash on 10.6.8 when going into fullscreen
* Critical fix: Crash on some Macs when connecting to a RDP server


Version 2.5 Build 46
--------------------
Released 11 Jan 2013

* RDP: Breaking changes to drive redirection / folder sharing:
    * Any folders defined in Build 45 will be removed from the server's
      configuration.
    * The folder sharing UI now lives in Jump's 'Preferences' area. Folders are
      defined and managed globally for all servers instead on a per-server
      basis.
    * Folder Sharing is DISABLED by default for new RDP connections. To enable
      the feature edit the server's 'Peripherals' section.
    * Lots of bug fixes to RDP redirection since build 45
* New: Quick Connect menu item in the dock icon
* New: Show a 'Settings' button when hovering over a computer's icon
* New: Add 2 buttons in the toolbar for 'Quick Connect' and 'Add new
  Connection'
* New: Added F10-F12 keys in the Remote->Send Key menu
* New: Smarter fullscreen mode: Uses Lion fullscreen mode on laptops / single
  monitor systems. Automatically switches to multi-monitor friendly fullscreen
  mode on multi-mon systems. Also unifies full screen experience when pressing
  the top right hand corner fullscreen chrome button.
* New: Default Windows keyboard windows profile maps word skipping keys (Alt +
  Left and right arrows) to Windows equivalent of Ctrl + Left / Right.
* Fixed: Keyboard input stops working temporarily when the user clicks Remote
  -> Send Ctlr+Alt+Del
* Fixed: Auto start option could not be removed
* Fixed: Click on jump:// URL while Jump is not running does not launch the URL
* Fixed: Domain name was not being parsed in the 'Windows Credentials' prompt
* Fixed: Clipboard related crashes


Version 2.5 Build 45
--------------------
* New: RDP: Drive redirection / folder sharing feature. WARNING: Please make
  sure you backup your data before data using this feature. Do not use for
  production data until we officially release the feature:
  ![](http://grab.by/iGZg)
* New: RDP: Rich text support for Clipboard copy/paste operations
* New: Experimental 'Keepalive' feature to prevent remote connections from
  terminating when a session is left idle. This is enabled by default on all
  connections and can not be turned off.
* Fixed: RDP: clipboard synchronization issues (include line endings not
  properly being sent to the remote computer)
* Fixed: RDP: Regressions in Build 44 and 43 which caused RDP connections to
  fail to Vista and Server 2008 machines (pre SP1)
* Fixed: RDP: Make sure NumLock is always enabled
* VNC: Performance optimizations to TightVNC encoding


Version 2.1 Build 44
--------------------
* New: Jump's icon does not bounce in the dock. If you want to re-enable the
  old behaviour please turn it on in Preferences.
* Fixed: RDP: Printing failure in the AppStore version of Jump (this does not
  effect beta and web versions of Jump)
* Fixed: RDP: British keyboard layout where '|' was incorrectly mapped to '~'
* Fixed: RDP: Add Swiss German keyboard mapping
* Fixed: Minimize button not showing up when exiting fullscreen mode
* Fixed: Cursor is now more prominent on darker backgrounds
* Fixed: Clipboard: Make sure copy-paste formatting is preserved when pasting
  to/from Windows machines
* Fixed: Clipboard: Pasting sometimes truncated or added gibberish to text


Version 2.1 Build 43
--------------------

* RDP: New RDP compression scheme that reduces bandwidth consumption by up to
  30% on Windows Vista and later operating systems
* Fixed: RDP: Upper left hand corner key and ~ key was not working properly on
  some keyboards
* Fixed: The disconnect shortcut has been changed from Ctrl+Cmd+Q to Cmd+W
* Fixed: Cursor is invisible when it's the same color as the background
* RDP: If a window starts in non-fullscreen mode, it'll use the resolution of
  the visible Mac desktop and not the monitor's own resolution, unless you
  check the 'Fullscreen' option by editing the server's Display settings in
  Jump
* New Fullscreen customization options in 'General Preferences' pane
* Zoom settings are described and laid out in a more user-friendly way

Version 2.0 Build 41
--------------------
Released Nov 20th 2012

* Fixed: Crash when exiting fullscreen using keyboard shortcuts
* Fixed: Black bars around RDP screen when the resolution is set to 'Match
  Screen' and we enter Fullscreen mode
* Fixed: Black bars shown around content when connecting to computer with a
  larger screen and different aspect ratio

Version 2.0 Build 40
--------------------
Released Nov 16th 2012

* Another potential fix for fullscreen crash


Version 2.0 Build 39
--------------------
Released Nov 16th 2012

#### New Stuff
* Low bandwidth quality modes for VNC connections: `Black and White` and
  `Grayscale`.
* Ability to change VNC quality settings without disconnecting: Click `View` ->
  `Quality`
* Added `None` option to Zoom settings in `Preferences` -> `Zoom`
* Completely hide the local Mac Dock when in full screen mode. The old
  behaviour was to show the local dock automatically when the mouse hit the
  bottom of the screen
* Support for Win 8 RDPs HiDPI mode.
* Support for parsing XML RDP files (created by Microsoft Remote Desktop
  Connection for Mac)
* Remove the black area around the screen when in Windowed mode
* Disabled mouse pointer updates when connecting to Mac ARD
* Performance updates

#### Bug fixes

* Fixed: Fixed a case where we don't show reconnection option when
  disconnecting from RDP sessions
* Fixed: Connection notification was not shown when pressing 'Try again'
* Fixed: Multiple fixes to `mouse centred` mode when zoomed in
* Attempted fixed: Crashes when going in / out of fullscreen


Version 2.0 Build 38
--------------------
Released Nov 7th 2012 ####Bug Fixes
* Fixed: Alt modifier was being sent out of order causing Alt combinations not
  to work properly
* Fixed: Typo when parsing RDP height field in .rdp files
* Fixed: Crash when sending the Cmd modifier
* Fixed: Cmd + ` (Cycle Window) was not working for the main Jump Desktop
  window
* Fixed: Dictation on RDP connections gets confused when lots of text is sent
  at once
* Fixed: RDP Audio redirection for VirtualBox connections stopped working
* Fixed: X11RDP was not working properly (partial fix)
* Fixed: Crash when disconnecting in fullscreen mode

Version 2.0 Build 37
--------------------
Released Nov 2nd 2012

#### New Features
* New screen panning modes. Super useful when connecting to big screens / multi
  monitor systems from a smaller laptop ![](http://grab.by/heCW)
* Remote Printing support for RDP.
* Support for Mountain Lion's dictation feature.
* Handlers for jump://, vnc:// and rdp:// URL schemes. See [this
  article](http://support.jumpdesktop.com/entries/371238-starting-jump-desktop-from-other-applications)
  for some examples.
* Jump Desktop ca now be set as the default app to handle VNC and RDP URLs on a
  system wide level with one click (Preferences -> General).
* Scrollbars are visible in the remote window when user is zoomed in.
* Support for VPN-on-Demand.
* RDP: Support for Server Redirection feature.

#### Bug fixes
* Lots of keyboard fixes:
    * Pressing Alt + Shift now works in Windows
    * Modifier queuing is disabled when shortcut and mapping are disabled in
      the keyboard profile
    * Modifier queuing is disabled when a mouse button is pressed
    * Internationalization fixes for ARD, VNC and RDP (dead keys are now
      processed correctly)
* Fixes a bug which will disable autofill feature of name field in Add New
  Connection window
* Removes name field from Quick Connections window.
* Fixed an issue which caused CPU usage to spike when disconnecting from a RDP
  session
* Fixes a bug which would crash the application if user used options in the
  General pane of the Preferences window.
* Fixed: 'Remote -> Send Key' was not sending input to the remote computer
* RDP: Fixed an issue when connecting to computers with FIPS encryption set
* RDP: Fixed visual artifacts when using 8bit color mode
* RDP: Fixed incorrect mouse pointers being shown when connecting to Windows
  machines


Version 2.0 Build 35
--------------------
Released Sep 14, 2012

Please send all beta related feedback to: <betasupport@jumpdesktop.com>

* Critical bug fix: Fixes a regression from build 34 which capitalized all
  keystrokes when connecting to PC and Linux machines via VNC.

* Experimental fullscreen bug fixes when coming out of fullscreen mode and
  disconnecting.



Version 2.0 Build 34
--------------------
Released Sep 14, 2012

Please send all beta related feedback to: <betasupport@jumpdesktop.com>

* Added support for international keyboards when connecting to another Mac
* More keyboard layouts for RDP


---
Version 2.0 Build 33
--------------------
Released Aug 29, 2012

## Features
* In the main window, search start immediately as soon as user starts typing on
  the keyboard. Previously user had to click on the search box.
* Alternatively, user can focus on the search box by pressing '/' or '?' or
  'CMD+F' keys.
* User can search for connected computer using the keyword 'connected' in the
  search box.

![](http://grab.by/fI1Y)

* Reconnect button in error dialogs.

![](http://grab.by/fI1E)

* Ability to edit display name right in the Add New Computer window.

![](http://grab.by/fI0Y)

* Better support for mouse pointer updates.
* Better logging to help fixing the bugs and crashes.

## UI
* New icons.

![](http://grab.by/fI38)

* Adds link to Twitter and Facebook in help menu.

![](http://grab.by/fI2e)

## Bug fixes
* Fix crash when disconnecting in full screen mode.
* Matches Mac Keyboard with remote RDP servers.
* SSH port number is parsed properly.
* Connection type is focused whenever Add New Computer window is launched.

